const express = require("express");
const router = express.Router();

router.get("/web-identity", (req, res) => {
	res.json({
		"provider_urls": [ `${process.env.IDP_DOMAIN}/.well-known/fedcm.json` ]
	})
})

router.get("/fedcm.json", (req, res) => {
	res.json({
		accounts_endpoint: "/api/fedcm/accounts",
		client_metadata_endpoint: "/api/fedcm/metadata",
		id_assertion_endpoint: "/api/fedcm/idtokens",
		disconnect_endpoint: "/api/fedcm/disconnect",
		login_url: "/?fedcm_login=1",
		branding: {
			background_color: "#6200ee",
			color: "#ffffff",
			icons: [{
				url: `${process.env.IDP_DOMAIN}/public/img/favicon.svg`,
				size: 512
			}]
		}
	})
})

module.exports = router;