const csrfCheck = (req, res, next) => {
	if (!(
		req.header("X-Requested-With") === "XMLHttpRequest" ||
		req.header("Sec-Fetch-Dest") === "webidentity"
	)) return res.status(400).json({ error: "Invalid access." });

	next();
};

const apiSessionCheck = (req, res, next) => {
	if (!req.session.username) return res.status(401).json({ error: "not signed in." });

	res.locals.user = req.app.locals.USERS.filter((user) => user.username === req.session.username)[0];
	if (!res.locals.user) return res.status(401).json({ error: "database has been cleared, please reconnect." });
	next();
};

const appSessionCheck = (req, res, next) => {
	if (!req.session.username) return res.redirect(307, "/?error=not%20signed%20in");

	const user = req.app.locals.USERS.filter((user) => user.username === req.session.username)[0];
	if (!user) return res.redirect(307, "/?error=database%20has%20been%20cleared%20please%20reconnect");
	next();
}

import NodeCache from "node-cache";
const cache = new NodeCache({ stdTTL: 60 });
const cacheMiddleware = (req, res, next) => {
	const cacheId = req.cookies["cacheId"] || res.locals.cacheId;
	const key = `${cacheId}||${req.cookies['connect.sid']}||${req.originalUrl}`;
	const cachedResponse = cache.get(key);

	if (cachedResponse) {
		Object.entries(cachedResponse.headers).forEach(([header, value]) => {
			res.set(header, value);
		});
		res.set("X-DYNAMIC-Cache", "HIT");
		return res.status(cachedResponse.statusCode).send(cachedResponse.body);
	}

	res.sendResponse = res.json;
	res.json = (body) => {
		res.set("X-DYNAMIC-Cache", "MISS");
		cache.set(key, {
			statusCode: res.statusCode,
			headers: res.getHeaders(),
			body
		});
		res.sendResponse(body);
	};

	next();
};

export { csrfCheck, apiSessionCheck, appSessionCheck, cacheMiddleware };