const { apiSessionCheck, cacheMiddleware } = require("./utils");
const express = require("express");
const fedcm = require("./fedcm");
const csrf = require("csurf");
const cors = require("cors");

const csrfMiddleware = csrf({ cookie: { httpOnly: true, secure: true, sameSite: "None"} });
const router = express.Router();
router.use(
cors({
	origin: true,
	credentials: true,
	exposedHeaders: "X-Csrf-Token"
})
);

router.post("/login", csrfMiddleware, (req, res) => {
	const username = req.body.username;
	const password = req.body.password;

	if (!username || !password) return res.status(401).json({ error: "Username and password must be provided." });
	if (req.app.locals.FORBIDDEN_USERNAMES.includes(username)) return res.status(401).json({ error: "Forbidden username." });
	if (password.length < 8) return res.status(401).json({ error: `Password must be at least 8 characters long.` });

	var user = req.app.locals.USERS.filter((user) => { return user.username === username })[0];
	if (user && user.password !== password) return res.status(401).json({ error: "Invalid password provided." });
	if (!user) {
		user = {
			id: crypto.randomUUID(),
			username: username,
			email: `${username}@molecule.fr`,
			password: password,
			secret: crypto.randomUUID(),
			approved_clients: []
		}
		req.app.locals.USERS.push(user);
	}

	req.session.username = user.username;
	res.set("Set-Login", "logged-in"); // https://developers.google.com/privacy-sandbox/blog/fedcm-chrome-120-updates
	res.json(user);
})

router.post("/me", cacheMiddleware, csrfMiddleware, apiSessionCheck, (req, res) => {
	const user = res.locals.user;
	return res.json({
		id: user.id,
		username: user.username,
		email: user.email,
		secret: "-"
	});
})

router.post("/logout", csrfMiddleware, apiSessionCheck, (req, res) => {
	delete req.session.username;
	res.set("Set-Login", "logged-out");
	res.cookie("cacheId", crypto.randomUUID(), {
		httpOnly: true,
		secure: true,
		sameSite: "none",
		maxAge: 1000 * 60 * 60 * 24 // 1 day
	});
	return res.status(200).json({ status: "Ok." });
})

router.use("/fedcm", fedcm);
module.exports = router;