tailwind.config = {
	darkMode: "class",
};

const html = document.documentElement;
if (localStorage.getItem("theme") === "dark") {
	html.classList.add("dark");
} else {
	html.classList.remove("dark");
}

document.addEventListener("DOMContentLoaded", function() {
	const toggleButton = document.getElementById("toggle-icon");
	const logoutButton = document.getElementById("logout-btn");
	const csrfToken = document.querySelector("meta[name=csrf-token]").content;

	if (localStorage.getItem("theme") === "dark") {
		toggleButton.innerHTML = "🌙";
	} else {
		toggleButton.innerHTML = "🌞";
	}

	toggleButton.addEventListener("click", function() {
		html.classList.toggle("dark");

		if (html.classList.contains("dark")) {
			localStorage.setItem("theme", "dark");
			this.innerHTML = "🌙";
		} else {
			localStorage.setItem("theme", "light");
			this.innerHTML = "🌞";
		}
	});

	logoutButton.addEventListener("click", async function() {
		const response = await fetch("/api/logout", { method: "POST", headers: { "X-CSRF-Token": csrfToken } });
		if (response.ok) {
			location.href = "/";
		}
	})
});