document.addEventListener("DOMContentLoaded", async function() {
	const csrfToken = document.querySelector("meta[name=csrf-token]").content;
	const response = await fetch("/api/me", { method: "POST", credentials: "include", headers: { "X-CSRF-Token": csrfToken } });
	if (response.ok) {
		const user = await response.json();
		document.getElementById("user-id").value = user.id;
		document.getElementById("user-username").value = user.username;
		document.getElementById("user-email").value = user.email;
		document.getElementById("user-secret").value = user.secret;
	}
});