document.getElementById("login-form").addEventListener("submit", async function(event) {
	event.preventDefault();

	const params = new URL(location.href).searchParams;
	const csrfToken = document.querySelector("meta[name=csrf-token]").content;
	const username = document.getElementById("username").value;
	const password = document.getElementById("password").value;
	const errorBox = document.getElementById("error-box");

	try {
		const response = await fetch("/api/login", {
			method: "POST",
			headers: {
				"X-CSRF-Token": csrfToken,
				"Content-Type": "application/json"
			},
			body: JSON.stringify({ username, password })
		});

		const result = await response.json();
		if (response.ok) {
		if (params.get("fedcm_login")) return IdentityProvider.close();
			const redirect_uri = params.get("redirect_uri");
			window.location.href = redirect_uri && redirect_uri.startsWith("http") ? redirect_uri : "/profile";
		} else {
			errorBox.textContent = result.error || "Invalid login credentials.";
			errorBox.classList.remove("hidden");
		}
	} catch (error) {
		errorBox.textContent = "Something went wrong. Please try again.";
		errorBox.classList.remove("hidden");
	}
});