const acceptButton = document.getElementById("accept-btn");
const rejectButton = document.getElementById("reject-btn");

acceptButton.addEventListener("click", async function(e) {
	e.preventDefault();
	const url = new URL(location.href);
	const client_id = url.searchParams.get("client_id");
	const scope = url.searchParams.get("scope");

	const response = await fetch("/api/fedcm/token", {
		method: "POST",
		headers: { "Content-Type": "application/json", "X-Requested-With": "XMLHttpRequest" },
		body: JSON.stringify({ client_id, scope }),
	});

	if (response.status === 200) {
		const { token } = await response.json();
		IdentityProvider.resolve(token);
	} else {
		const result = await response.json();
		throw result.error;
	}
});

rejectButton.addEventListener("click", function(e) {
	IdentityProvider.close();
});