// Force puppeteer to store everything to /tmp/
process.env.HOME = "/tmp";

const { delay, handleTargetCreated, handleTargetDestroyed, logMainInfo, logMainError } = require("./utils");
const puppeteer = require("puppeteer");

// Banner
const tips = ["Every console.log usage on the bot will be sent back to you :)"];
console.log(`==========\nTips: ${tips[Math.floor(Math.random() * tips.length)]}\n==========`);

// Restrict access to a specific domain of a TLD.
const PAC_B64 = Buffer.from(`
function FindProxyForURL (url, host) {
	if (host == "${new URL(process.env.APP_DOMAIN).hostname}" || host == "${new URL(process.env.IDP_DOMAIN).hostname}") return "DIRECT";
	if (host.endsWith("fcsc.fr")) return "PROXY 127.0.0.1:1";
	return "DIRECT";
}
`).toString("base64");

// Spawn the bot and navigate to the user provided link
async function goto(url) {
	logMainInfo("Starting the browser...");
	console.log(process.env.APP_DOMAIN, process.env.IDP_DOMAIN)
	const browser = await puppeteer.launch({
		headless: "new",
		ignoreHTTPSErrors: true,
		args: [
			"--no-sandbox",
			"--disable-gpu",
			"--disable-jit",
			"--disable-wasm",
			"--disable-dev-shm-usage",
			`--proxy-pac-url=data:application/x-ns-proxy-autoconfig;base64,${PAC_B64}`,
			/* ** CHALLENGE RELATED OPTIONS ** */
			"--test-third-party-cookie-phaseout",
			"--enable-features=AllowSameSiteNoneCookiesInSandbox",
			`--unsafely-treat-insecure-origin-as-secure=${process.env.APP_DOMAIN},${process.env.IDP_DOMAIN}`,
		],
		executablePath: "/usr/app/chrome/linux-135.0.6999.2/chrome-linux64/chrome"
	});

	// Hook tabs events
	browser.on("targetcreated", handleTargetCreated.bind(browser));
	browser.on("targetdestroyed", handleTargetDestroyed.bind(browser));

	/* ** CHALLENGE LOGIC ** */
	const page = await browser.newPage();
	await page.setDefaultNavigationTimeout(5000);

	browser.on("targetcreated", async target => {
		if (target.type() === "page") {
			const page = await target.page();
			if (!page || page.url() !== `${process.env.IDP_DOMAIN}/profile`) return;
			await page.waitForSelector("body");
			await page.click("body");
		}
	});

	logMainInfo("Setting up the FedCM auto-login...");
	const handleFedCM = async function (event) {
		const dialogId = event.dialogId;
		if (event.accounts[0].email === `${process.env.BOT_USERNAME}@molecule.fr`) {
			await this.send("FedCm.selectAccount", { 
				dialogId: dialogId,
				accountIndex: 0
			});
			await delay(1000); // FedCM auto-login delay
			const pages = await browser.pages();
			for (const page of pages) {
				if (page.url() === `${process.env.IDP_DOMAIN}/authorization?client_id=${process.env.APP_DOMAIN}&scope=id,username,secret`) {
					await page.waitForSelector("#accept-btn");
					await page.click("#accept-btn");
					return;
				}
			}
			logMainError("Can't find the FedCM Authorization page!");
			await browser.close();
			return;
		}
	}
	const client = await page.createCDPSession();
	await client.send("FedCm.enable"); // Enable FedCM auto-login
	client.on("FedCm.dialogShown", handleFedCM.bind(client));

	logMainInfo("Log-in the bot to the IDP...");
	await page.goto(process.env.IDP_DOMAIN);
	await page.waitForSelector("#password");
	await page.type("#username", process.env.BOT_USERNAME);
	await page.type("#password", process.env.BOT_PASSWORD);
	await page.keyboard.press("Enter");
	await page.waitForNavigation();
	await page.goto(`${process.env.APP_DOMAIN}?auto_login`); // Setting-up the cache (service worker)
	await delay(2000);

	logMainInfo("Going to the user provided link...");
	try { await page.goto(url) } catch {}
	await delay(15000);

	logMainInfo("Leaving o/");
	await browser.close();
	return;
}

// Handle TCP data
process.stdin.on("data", (data) => {
	const url = data.toString().trim();

	if (!url || !(url.startsWith("http://") || url.startsWith("https://"))) {
		console.log("[ERROR] Invalid URL!");
		process.exit(1);
	}

	goto(url)
	.then(() => process.exit(0))
	.catch((error) => {
		if (process.env.ENVIRONMENT === "development") {
			console.error(error);
		}
		process.exit(1);
	});
});