const path = require("path");
const HtmlWebpackPlugin = require("html-webpack-plugin");
const CopyWebpackPlugin = require("copy-webpack-plugin");

module.exports = {
	entry: "./src/index.js",
	output: {
		path: path.resolve(__dirname, "build"),
		filename: "static/bundle.js",
		publicPath: "/"
	},
	module: {
		rules: [
		{
			test: /\.(js|jsx)$/,
			exclude: /node_modules/,
			use: {
			loader: "babel-loader",
			options: {
				presets: ["@babel/preset-env", "@babel/preset-react"]
			}
			}
		},
		{
			test: /\.css$/,
			use: [
			"style-loader",
			"css-loader",
			"postcss-loader"
			]
		},
		{
			test: /\.(png|svg|jpg|jpeg|gif|ico)$/,
			type: "asset/resource"
		}
		]
	},
	plugins: [
		new HtmlWebpackPlugin({
			template: "./public/index.html",
			filename: "index.html"
		}),
		new CopyWebpackPlugin({
		patterns: [
			{ 
				from: "public",
				globOptions: {
					ignore: ["**/index.html"]
				}
			}
		]
		})
	],
	resolve: {
		extensions: [".js", ".jsx"]
	},
	devServer: {
		static: {
			directory: path.join(__dirname, "build"),
		},
		port: 3000,
		hot: true,
		historyApiFallback: true
	}
};