export const setFileInUrl = (projectId, fileId, shouldRender = false) => {
	const searchParams = new URLSearchParams(window.location.search);
	if (projectId && fileId) {
		searchParams.set("projectId", projectId);
		searchParams.set("fileId", fileId);
		if (shouldRender) {
			searchParams.set("render", "true");
		} else {
			searchParams.delete("render");
		}
	} else {
		searchParams.delete("projectId");
		searchParams.delete("fileId");
		searchParams.delete("render");
	}
	
	const newUrl = `${window.location.pathname}${searchParams.toString() ? "?" + searchParams.toString() : ""}`;
	window.history.pushState({}, "", newUrl);
};

export const getFileFromUrl = () => {
	const searchParams = new URLSearchParams(window.location.search);
	const projectId = searchParams.get("projectId");
	const fileId = searchParams.get("fileId");
	const render = searchParams.get("render") === "true";
	
	return projectId && fileId ? {
		projectId: projectId,
		fileId: fileId,
		render
	} : null;
};