import { useEffect } from "react";

export const useKeyboardShortcut = (activeTab, handleSave, handlePreviewToggle) => {
	useEffect(() => {
		const handleKeyDown = (e) => {
		if (e.ctrlKey || e.metaKey) {
			if (e.key === "s") {
				e.preventDefault();
			if (activeTab) {
				handleSave(activeTab);
			}
			} else if (e.key === "p" && activeTab) {
				e.preventDefault();
				handlePreviewToggle(activeTab);
			}
		}
		};

		window.addEventListener("keydown", handleKeyDown);
		return () => window.removeEventListener("keydown", handleKeyDown);
	}, [activeTab, handleSave, handlePreviewToggle]);
};