import DOMPurify from "dompurify";

export const parseMarkdown = (content) => {
	if (!content) return "";
	let html = content;

	// Headers
	html = html.replace(/^### (.*$)/gm, `<h3 class="text-xl font-bold mt-4 mb-2">$1</h3>`);
	html = html.replace(/^## (.*$)/gm, `<h2 class="text-2xl font-bold mt-6 mb-3">$1</h2>`);
	html = html.replace(/^# (.*$)/gm, `<h1 class="text-3xl font-bold mt-8 mb-4">$1</h1>`);
	
	// Lists
	html = html.replace(/^\- (.+)/gm, `<li class="ml-4">$1</li>`);
	html = html.replace(/^\* (.+)/gm, `<li class="ml-4">$1</li>`);
	html = html.replace(/(<li[^>]*>.*<\/li>)\n(<li[^>]*>.*<\/li>)/g, `<ul class="my-2">$1$2</ul>`);
	
	// Emphasis
	html = html.replace(/\*\*([^*]+)\*\*/g, `<strong class="font-bold">$1</strong>`);
	html = html.replace(/\*([^*]+)\*/g, `<em class="italic">$1</em>`);
	
	// Paragraphs
	html = html.split("\n").map(line => {
		if (line.trim() === "") return "";
		if (line.startsWith("<")) return line;
		return `<p class="mb-4">${line}</p>`;
	}).join("");

	return DOMPurify.sanitize(html);
};