export const getFileType = (filename) => {
	const extension = filename.split(".").pop().toLowerCase();
	const fileTypes = {
		"md": "md",
		"markdown": "md",
		"css": "css",
		"js": "javascript",
		"jsx": "javascript",
		"json": "json",
		"html": "html",
		"txt": "text"
	};
	
	return fileTypes[extension] || "text";
};

export const isValidFilename = (filename) => {
	if (!filename || typeof filename !== "string") return false;
	
	const validFilenameRegex = /^[a-zA-Z0-9-_.\s]+$/;
	if (!validFilenameRegex.test(filename)) return false;
	if (!filename.includes(".")) return false;
	if (filename.startsWith(".")) return false;
	
	return true;
};

export const createFileObject = (name, content = "") => {
	return {
		id: Date.now(),
		name,
		content,
		type: getFileType(name)
	};
};

export const createProjectObject = (name) => {
	return {
		id: Date.now(),
		name,
		files: []
	};
};

export const generateUniqueFilename = (existingFiles, baseName) => {
	const extension = baseName.split(".").pop();
	const nameWithoutExt = baseName.slice(0, -(extension.length + 1));
	let counter = 1;
	let newName = baseName;

	while (existingFiles.some(file => file.name === newName)) {
		newName = `${nameWithoutExt}-${counter}.${extension}`;
		counter++;
	}

	return newName;
};