import React from "react";

const variantStyles = {
	default: "hover:bg-gray-700",
	danger: "hover:bg-red-700 text-red-500 hover:text-white",
	ghost: "hover:bg-gray-700/50"
};

const sizeStyles = {
	sm: "p-1",
	md: "p-2",
	lg: "p-3"
};

const IconButton = ({
	icon,
	variant = "default",
	size = "md",
	className = "",
	title,
	onClick,
	...props
}) => {
	const baseClasses = "rounded transition-colors duration-200 flex items-center justify-center";
	const variantClass = variantStyles[variant];
	const sizeClass = sizeStyles[size];

	return (
		<button
			className={`${baseClasses} ${variantClass} ${sizeClass} ${className}`}
			onClick={onClick}
			title={title}
			{...props}
		>
			{icon}
		</button>
	);
};

export default IconButton;