import React from "react";

const variantStyles = {
	primary: "bg-blue-600 hover:bg-blue-700 text-white",
	success: "bg-green-600 hover:bg-green-700 text-white",
	danger: "bg-red-600 hover:bg-red-700 text-white",
	ghost: "hover:bg-gray-700 text-gray-300",
	disabled: "bg-gray-700 text-gray-400 cursor-not-allowed"
};

const sizeStyles = {
	sm: "px-2 py-1 text-sm",
	md: "px-4 py-2",
	lg: "px-6 py-3 text-lg"
};

const Button = ({
	children,
	variant = "primary",
	size = "md",
	disabled = false,
	className = "",
	icon,
	title,
	onClick,
	...props
}) => {
	const baseClasses = "rounded flex items-center justify-center transition-colors duration-200";
	const variantClass = disabled ? variantStyles.disabled : variantStyles[variant];
	const sizeClass = sizeStyles[size];

	return (
		<button
			className={`${baseClasses} ${variantClass} ${sizeClass} ${className}`}
			disabled={disabled}
			onClick={disabled ? undefined : onClick}
			title={title}
			{...props}
		>
			{icon && <span className="mr-2">{icon}</span>}
			{children}
		</button>
	);
};

export default Button;