import React from "react";
import Sidebar from "./Sidebar";
import Editor from "./Editor";
import { useFileSystem } from "../../hooks/useFileSystem";
import { useKeyboardShortcut } from "../../utils/shortcuts";

const MoleculeEditor = () => {
	const {
		projects,
		openTabs,
		activeTab,
		fileContents,
		unsavedChanges,
		lastSaved,
		previewMode,
		handleSave,
		handleFileOpen,
		handleTabClose,
		handleContentUpdate,
		handlePreviewToggle,
		setActiveTab,
		addProject,
		deleteProject,
		addFile,
		deleteFile,
		renameProject,
		renameFile
	} = useFileSystem();

	useKeyboardShortcut(activeTab, handleSave, handlePreviewToggle);

	return (
		<div className="h-screen flex overflow-hidden">
		<Sidebar
			projects={projects}
			onFileOpen={handleFileOpen}
			unsavedChanges={unsavedChanges}
			onAddProject={addProject}
			onDeleteProject={deleteProject}
			onAddFile={addFile}
			onDeleteFile={deleteFile}
			onRenameProject={renameProject}
			onRenameFile={renameFile}
		/>
		<Editor
			openTabs={openTabs}
			activeTab={activeTab}
			fileContents={fileContents}
			unsavedChanges={unsavedChanges}
			lastSaved={lastSaved}
			previewMode={previewMode}
			onSave={handleSave}
			onClose={handleTabClose}
			onContentUpdate={handleContentUpdate}
			onPreviewToggle={handlePreviewToggle}
			onTabSelect={setActiveTab}
		/>
		</div>
	);
};

export default MoleculeEditor;