import React, { useState } from "react";
import { Plus } from "lucide-react";
import FileTree from "./FileTree";
import IconButton from "../shared/IconButton";

const Sidebar = ({
	projects,
	onFileOpen,
	unsavedChanges,
	onAddProject,
	onDeleteProject,
	onAddFile,
	onDeleteFile,
	onRenameProject,
	onRenameFile
}) => {
	const [showNewProjectInput, setShowNewProjectInput] = useState(false);
	const [newProjectName, setNewProjectName] = useState("");
	const [showNewFileInput, setShowNewFileInput] = useState(null);
	const [editingName, setEditingName] = useState({ type: null, id: null });

	const handleAddProject = () => {
		if (newProjectName.trim()) {
			onAddProject(newProjectName);
			setNewProjectName("");
			setShowNewProjectInput(false);
		}
	};

	const handleNewFile = (projectId, fileName) => {
		if (!fileName.trim()) return;
		onAddFile(projectId, fileName);
		setShowNewFileInput(null);
	};

	return (
		<div className="w-64 bg-gray-800 text-white p-4 flex flex-col">
			<div className="flex justify-between items-center mb-4">
				<h2 className="text-xl font-bold">Projects</h2>
				<IconButton
					onClick={() => setShowNewProjectInput(true)}
					icon={<Plus size={20} />}
					variant="ghost"
				/>
			</div>

			{showNewProjectInput && (
				<div className="mb-4 flex">
					<input
						type="text"
						value={newProjectName}
						onChange={(e) => setNewProjectName(e.target.value)}
						onKeyPress={(e) => e.key === "Enter" && handleAddProject()}
						onBlur={handleAddProject}
						className="flex-1 bg-gray-700 text-white px-2 py-1 rounded"
						placeholder="Project name"
						autoFocus
					/>
				</div>
			)}

			<div className="flex-1 overflow-y-auto">
				<FileTree
					projects={projects}
					showNewFileInput={showNewFileInput}
					editingName={editingName}
					unsavedChanges={unsavedChanges}
					onFileOpen={onFileOpen}
					onNewFile={handleNewFile}
					onDeleteProject={onDeleteProject}
					onDeleteFile={onDeleteFile}
					onRenameProject={onRenameProject}
					onRenameFile={onRenameFile}
					setShowNewFileInput={setShowNewFileInput}
					setEditingName={setEditingName}
				/>
			</div>
		</div>
	);
};

export default Sidebar;