import React from "react";
import { X } from "lucide-react";
import IconButton from "../shared/IconButton";
import { setFileInUrl } from "../../utils/urlUtils";

const EditorTabs = ({ tabs, activeTab, unsavedChanges, onTabSelect, onTabClose, previewMode }) => {
	const handleTabClick = (tab) => {
		onTabSelect(tab.id);
		setFileInUrl(tab.projectId, tab.file.id, previewMode[tab.id] || false);
	};

	return (
		<div className="flex bg-gray-800 text-gray-300">
			{tabs.map(tab => (
				<div
					key={tab.id}
					className={`flex items-center px-4 py-2 border-r border-gray-700 cursor-pointer ${
						activeTab === tab.id ? "bg-gray-900 text-white" : "hover:bg-gray-700"
					}`}
					onClick={() => handleTabClick(tab)}
				>
					<span className="mr-2">{tab.file.name}</span>
					{unsavedChanges[tab.id] && <span className="mr-2 text-yellow-500">•</span>}
					<IconButton
						onClick={(e) => {
							e.stopPropagation();
							onTabClose(tab.id);
						}}
						icon={<X size={14} />}
						variant="ghost"
						size="sm"
					/>
				</div>
			))}
		</div>
	);
};

export default EditorTabs;