import React from "react";
import { Eye, Edit2, Save } from "lucide-react";
import EditorTabs from "./EditorTabs";
import { parseMarkdown } from "../../utils/markdownParser";
import Button from "../shared/Button";

const Editor = ({
	openTabs,
	activeTab,
	fileContents,
	unsavedChanges,
	lastSaved,
	previewMode,
	onSave,
	onClose,
	onContentUpdate,
	onPreviewToggle,
	onTabSelect
}) => {
	return (
		<div className="flex-1 flex flex-col bg-gray-900 overflow-hidden">
			<EditorTabs
				tabs={openTabs}
				activeTab={activeTab}
				unsavedChanges={unsavedChanges}
				onTabSelect={onTabSelect}
				onTabClose={onClose}
				previewMode={previewMode}
			/>

			{activeTab && (
				<div className="flex-1 flex flex-col overflow-hidden">
				{openTabs.map(tab => {
					if (tab.id === activeTab) {
					const isMarkdown = tab.file.type === "md";
					return (
						<div key={tab.id} className="flex flex-col h-full">
							<div className="flex items-center p-4 space-x-2 bg-gray-900">
								{isMarkdown && (
								<Button
									onClick={() => onPreviewToggle(tab.id)}
									variant="primary"
									icon={previewMode[tab.id] ? <Edit2 size={16} /> : <Eye size={16} />}
									title={"Toggle Preview (CTRL+P)"}
								>
									{previewMode[tab.id] ? "Edit" : "Preview"}
								</Button>
								)}
								<Button
									onClick={() => onSave(tab.id)}
									disabled={!unsavedChanges[tab.id]}
									variant={unsavedChanges[tab.id] ? "success" : "disabled"}
									icon={<Save size={16} />}
									title={"Save (CTRL+S)"}
								>
									Save
								</Button>
								{lastSaved[tab.id] && (
									<span className="text-gray-400">
										Last saved at {lastSaved[tab.id]}
									</span>
								)}
							</div>
							<div className="flex-1 overflow-auto">
								{previewMode[tab.id] ? (
									<div className="text-white p-4 markdown-preview">
										<div
											className="prose prose-invert prose-p:text-gray-300 prose-headings:text-white max-w-none"
											dangerouslySetInnerHTML={{ __html: parseMarkdown(fileContents[tab.id]) }}
										/>
									</div>
								) : (
									<textarea
										value={fileContents[tab.id] || ""}
										onChange={(e) => onContentUpdate(tab.id, e.target.value)}
										className="w-full h-full bg-gray-900 text-white p-4 font-mono resize-none focus:outline-none"
									/>
								)}
							</div>
						</div>
					);
					}
					return null;
				})}
				</div>
			)}
		</div>
	);
};

export default Editor;