import React, { useEffect, useState } from "react";
import { initiateAuth } from "../auth/fedcm";

const AuthWrapper = ({ children }) => {
	const [isAuthenticated, setIsAuthenticated] = useState(false);

	const handleSignIn = async () => {
		const isAuth = await initiateAuth();
		if (isAuth) {
			setIsAuthenticated(true);
		}
	};

	useEffect(() => {
		const params = new URL(location.href).searchParams;
		if (params.has("auto_login")) {
			params.delete("auto_login");
			window.history.replaceState({}, document.title, `${window.location.pathname}?${params}${window.location.hash}`);
			handleSignIn();
		}
	}, []);

	if (!isAuthenticated) {
		return (
			<div className="h-screen flex items-center justify-center bg-gray-900">
				<div className="max-w-2xl w-full bg-gray-800 rounded-lg shadow-2xl overflow-hidden">
					<div className="flex">
						{/* Image side */}
						<div className="w-1/2 bg-gray-700 overflow-hidden">
							<img 
								src="/static/img/login-banner.jpg" 
								alt="Molecule Editor"
								className="w-full h-full object-cover"
							/>
						</div>
							
						{/* Auth content */}
						<div className="w-1/2 p-8">
							<div className="space-y-6">
								<h1 className="text-2xl font-bold text-white mb-2">
									Molecule Editor
								</h1>
								<p className="text-gray-400 text-sm">
									Please authenticate to access the editor.
								</p>

								<div className="pt-4">
									<button 
										id="sign-in"
										onClick={handleSignIn}
										className="w-full bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium flex items-center justify-center"
									>
										Sign in with the IDP
									</button>
								</div>
								
								<p className="text-gray-500 text-xs text-center mt-4">
									Authentication provided by FedCM
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		);
	}

	return children;
};

export default AuthWrapper;