import { setToken } from "../utils/tokenStore";

export const initiateAuth = async () => {
	const response = await fetch("/api/auth/idp");
	const authConfig = await response.json();

	try {
		const credential = await navigator.credentials.get({
			identity: {
				providers: [{
					configURL: authConfig.configURL,
					clientId: authConfig.clientId,
					nonce: authConfig.idpNonce,
					params: {
						scope: authConfig.scope
					}
				}]
			}
		});

		if (credential?.token) {
			const { token, username } = await exchangeCodeForToken(credential.token, authConfig.idpNonce);
			if (token) {
				console.log(`[User Logged-in]> ${username}`);
				setToken(token);
				return true;
			}
		}
	} catch (error) {
		console.error("Authentication failed:", error);
	}

	window.location.href = `${authConfig.idpUrl}?redirect_uri=${encodeURIComponent(location.href)}`;
	return null;
};

const exchangeCodeForToken = async (code, nonce) => {
	try {
		const response = await fetch("/api/auth/callback", {
			method: "POST",
			headers: {
				"Content-Type": "application/json"
			},
			body: JSON.stringify({ code, nonce })
		});

		if (!response.ok) {
			throw new Error("Failed to exchange code for token");
		}

		const data = await response.json();
		return data;
	} catch (error) {
		console.error("Code exchange error:", error);
		return null;
	}
};
