const session = require("express-session");
const express = require("express");
const path = require("path");
const { router: authRouter, authenticateJWT } = require("./routers/auth");
const { router: apiRouter } = require("./routers/api");
const app = express();
const port = process.env.PORT || 5000;

app.use((req, res, next) => {
	if (req.headers.host !== process.env.APP_DOMAIN.split("//")[1]) {
		return res.redirect(302, process.env.APP_DOMAIN);
	}
	next();
});

app.use(session({
	secret: crypto.randomUUID(),
	resave: false,
	saveUninitialized: true,
	cookie: { secure: false }
}));

app.use((req, res, next) => {
	res.set("Content-Security-Policy", "script-src 'self'");
	next();
});

app.use(express.static(path.join(__dirname, "build")));
app.use(express.json());

app.use("/api/auth", authRouter);
app.use("/api/projects", authenticateJWT, apiRouter);

app.get("*", (req, res) => {
	res.sendFile(path.join(__dirname, "build", "404.html"));
});

app.listen(port, () => {
	console.log(`Server is running on port ${port}`);
});