importScripts("/static/js/workbox/workbox-sw.js");
workbox.setConfig({ modulePathPrefix: "/static/js/workbox/" });

if (workbox) {
	workbox.precaching.precacheAndRoute([
		{ url: "/static/bundle.js", revision: "1" }
	]);

	workbox.routing.registerRoute(
		({url}) => url.pathname.startsWith("/static/"),
		new workbox.strategies.CacheFirst({
			cacheName: "static-cache",
			plugins: [
				new workbox.expiration.ExpirationPlugin({
					maxAgeSeconds: 30 * 24 * 60 * 60 // 30 days
				}),
				{
					cacheKeyWillBeUsed: async ({ request }) => {
						const url = new URL(request.url);
						return url.pathname;
					},
					cachedResponseWillBeUsed: async ({ cacheName, request, cachedResponse }) => {
						if (cachedResponse) {
							console.log(`[Cache HIT]> ${request.url} (${cacheName})`);
						}
						return cachedResponse;
					}
				}
			]
		})
	);

	console.log("Workbox service-worker successfully loaded!");
} else {
	console.error("Workbox service-worker didn't load!");
}